<?php

/**
 * This is the model class for table "{{solicitud_reservacion}}".
 *
 * The followings are the available columns in table '{{solicitud_reservacion}}':
 * @property string $id_reservacion
 * @property integer $id_agencia
 * @property string $id_hotel
 * @property integer $id_usuario
 * @property integer $id_agente
 * @property integer $id_bloqueo
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property string $fecha_limite
 * @property string $fecha_limite_old
 * @property string $fecha_limite_h
 * @property string $fecha_liberacion
 * @property integer $usuario_liberacion
 * @property string $num_noches
 * @property string $observaciones
 * @property string $estatus
 * @property string $log
 * @property double $tipo_cambio
 * @property double $total
 * @property double $total_tc
 * @property double $tarifa_neta
 * @property double $tarifa_agencia
 * @property string $num_habitaciones
 * @property string $nombre_cliente
 * @property string $apellido_cliente
 * @property string $tel_cliente
 * @property string $id_tarifa
 * @property string $code
 * @property integer $id_tipo_plan
 * @property string $motivo
 * @property string $politicas_cancelacion
 * @property string $desglose_rate
 * @property integer $enviado
 * @property integer $moneda
 * @property integer $email
 */
class SolicitudReservacion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SolicitudReservacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{solicitud_reservacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, id_hotel, id_usuario, fecha_inicial, fecha_final, num_noches, estatus, total, total_tc, tarifa_neta, tarifa_agencia, num_habitaciones, nombre_cliente, apellido_cliente', 'required'),
			array('id_agencia, id_usuario, id_agente, id_bloqueo, usuario_liberacion, id_tipo_plan, enviado', 'numerical', 'integerOnly'=>true),
			array('tipo_cambio, total, total_tc, tarifa_neta, tarifa_agencia', 'numerical'),
			array('id_hotel', 'length', 'max'=>11),
			array('num_noches, num_habitaciones, id_tarifa', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>3),
			array('nombre_cliente, apellido_cliente, code, motivo', 'length', 'max'=>255),
			array('tel_cliente', 'length', 'max'=>45),
			array('fecha_limite, fecha_limite_old, fecha_limite_h, fecha_liberacion, observaciones, politicas_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_reservacion, cotizacion_url, id_agencia, id_hotel, id_usuario, id_agente, id_bloqueo, fecha_inicial, fecha_final, fecha_limite, fecha_limite_old, fecha_limite_h, fecha_liberacion, usuario_liberacion, num_noches, observaciones, estatus, log, tipo_cambio, total, total_tc, tarifa_neta, tarifa_agencia, num_habitaciones, nombre_cliente, apellido_cliente, tel_cliente, id_tarifa, code, id_tipo_plan, motivo, politicas_cancelacion, desglose_rate, enviado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

			//'cuentases' => array(self::HAS_MANY, 'Cuentas', 'id_reservacion'),

			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),			

			'idTipoPlan' => array(self::BELONGS_TO, 'Plan', 'id_tipo_plan'),

			//'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),

			'idAgente' => array(self::BELONGS_TO, 'Usuarios', 'id_agente'),

			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),

			'idUserLibera' => array(self::BELONGS_TO, 'Usuarios', 'usuario_liberacion'),

			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),

			'hotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

			'desglose' =>array(self::BELONGS_TO, 'SolicitudReservacionDesglose', 'id_reservacion'),


		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_reservacion' => 'Id Reservacion',
			'id_agencia' => 'Id Agencia',
			'id_hotel' => 'Id Hotel',
			'id_usuario' => 'Id Usuario',
			'id_agente' => 'Id Agente',
			'id_bloqueo' => 'Id Bloqueo',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'fecha_limite' => 'Fecha Limite',
			'fecha_limite_old' => 'Fecha Limite Old',
			'fecha_limite_h' => 'Fecha Limite H',
			'fecha_liberacion' => 'Fecha Liberacion',
			'usuario_liberacion' => 'Usuario Liberacion',
			'num_noches' => 'Num Noches',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'tipo_cambio' => 'Tipo Cambio',
			'total' => 'Total',
			'total_tc' => 'Total Tc',
			'tarifa_neta' => 'Tarifa Neta',
			'tarifa_agencia' => 'Tarifa Agencia',
			'num_habitaciones' => 'Num Habitaciones',
			'nombre_cliente' => 'Nombre Cliente',
			'apellido_cliente' => 'Apellido Cliente',
			'tel_cliente' => 'Tel Cliente',
			'id_tarifa' => 'Id Tarifa',
			'code' => 'Code',
			'id_tipo_plan' => 'Id Tipo Plan',
			'motivo' => 'Motivo',
			'politicas_cancelacion' => 'Politicas Cancelacion',
			'desglose_rate' => 'Desglose Rate',
			'enviado' => 'Enviado',
			'moneda' => 'Moneda',
			'email' => 'E-mail',
			'cotizacion_url' => 'Url de cotización',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agente',$this->id_agente);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('fecha_limite_old',$this->fecha_limite_old,true);
		$criteria->compare('fecha_limite_h',$this->fecha_limite_h,true);
		$criteria->compare('fecha_liberacion',$this->fecha_liberacion,true);
		$criteria->compare('usuario_liberacion',$this->usuario_liberacion);
		$criteria->compare('num_noches',$this->num_noches,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('tipo_cambio',$this->tipo_cambio);
		$criteria->compare('total',$this->total);
		$criteria->compare('total_tc',$this->total_tc);
		$criteria->compare('tarifa_neta',$this->tarifa_neta);
		$criteria->compare('tarifa_agencia',$this->tarifa_agencia);
		$criteria->compare('num_habitaciones',$this->num_habitaciones,true);
		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);
		$criteria->compare('apellido_cliente',$this->apellido_cliente,true);
		$criteria->compare('tel_cliente',$this->tel_cliente,true);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('id_tipo_plan',$this->id_tipo_plan);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('politicas_cancelacion',$this->politicas_cancelacion,true);
		$criteria->compare('desglose_rate',$this->desglose_rate,true);
		$criteria->compare('enviado',$this->enviado);
		$criteria->compare('email',$this->email);
		$criteria->compare('moneda',$this->moneda);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
