<?php

/**
 * This is the model class for table "{{solicitud_cancelacion}}".
 *
 * The followings are the available columns in table '{{solicitud_cancelacion}}':
 * @property integer $id_solicitud_cancelacion
 * @property string $motivo
 * @property string $id_reserva
 * @property string $id_usuario
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Reservacion $idReserva
 * @property Usuarios $idUsuario
 */
class SolicitudCancelacion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SolicitudCancelacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{solicitud_cancelacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_motivo, id_reserva, id_usuario', 'required'),
			array('comentario', 'length', 'max'=>200),
			array('id_reserva, id_usuario', 'length', 'max'=>10),

			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_solicitud_cancelacion, motivo, id_reserva, id_usuario, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idReserva' => array(self::BELONGS_TO, 'Reservacion', 'id_reserva'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'idMotivo' => array(self::BELONGS_TO, 'MotivosCancelacion', 'id_motivo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_solicitud_cancelacion' => 'Id Solicitud Cancelacion',
			'motivo' => 'Motivo',
			'id_reserva' => 'Id Reserva',
			'id_usuario' => 'Id Usuario',
			'tipo' => 'Tipo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_solicitud_cancelacion',$this->id_solicitud_cancelacion);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('id_reserva',$this->id_reserva,true);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}