<?php

/**
 * This is the model class for table "rooms".
 *
 * The followings are the available columns in table 'rooms':
 * @property string $id_tipo_habitacion
 * @property string $tipo_habitacion
 * @property string $descripcion
 * @property string $codigo
 * @property integer $max_adultos
 * @property integer $max_menores
 * @property integer $max_juniors
 * @property integer $paxextra
 * @property integer $estatus
 * @property string $log
 * @property integer $orden
 */
class Rooms extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Rooms the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rooms';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tipo_habitacion, descripcion, log', 'required'),
			array('max_adultos, max_menores, max_juniors, paxextra, estatus, orden', 'numerical', 'integerOnly'=>true),
			array('tipo_habitacion', 'length', 'max'=>255),
			array('codigo', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tipo_habitacion, tipo_habitacion, descripcion, codigo, max_adultos, max_menores, max_juniors, paxextra, estatus, log, orden', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'tipo_habitacion' => 'Tipo Habitacion',
			'descripcion' => 'Descripcion',
			'codigo' => 'Codigo',
			'max_adultos' => 'Max Adultos',
			'max_menores' => 'Max Menores',
			'max_juniors' => 'Max Juniors',
			'paxextra' => 'Paxextra',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'orden' => 'Orden',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('tipo_habitacion',$this->tipo_habitacion,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('max_adultos',$this->max_adultos);
		$criteria->compare('max_menores',$this->max_menores);
		$criteria->compare('max_juniors',$this->max_juniors);
		$criteria->compare('paxextra',$this->paxextra);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('orden',$this->orden);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}