<?php

/**
 * This is the model class for table "{{roominglist_log}}".
 *
 * The followings are the available columns in table '{{roominglist_log}}':
 * @property integer $id_log
 * @property string $Movimiento
 * @property string $valores
 * @property integer $id_usuario
 * @property integer $id_roominglist
 * @property integer $id_bloqueo
 * @property string $log
 */
class RoominglistLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RoominglistLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{roominglist_log}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('movimiento, id_usuario, id_roominglist, id_bloqueo', 'required'),
			array('id_usuario, id_roominglist, id_bloqueo', 'numerical', 'integerOnly'=>true),
			array('movimiento', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_log, movimiento, valor, id_usuario, id_roominglist, id_bloqueo, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			/*'idBloqueo'=>array(BELONGS_TO, 'Bloqueos','id_bloqueo'),
			'idRooming'=>array(BELONGS_TO, 'Roominglist','id_roominglist'),
			'User'=>array(BELONGS_TO, 'Usuarios','id_usuario'),
			*/
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'idRooming'=>array(self::BELONGS_TO, 'Roominglist','id_roominglist'),
			'User'=>array(self::BELONGS_TO, 'Usuarios','id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_log' => 'Id Log',
			'movimiento' => 'Movimiento',
			'valor' => 'Valor',
			'id_usuario' => 'Id Usuario',
			'id_roominglist' => 'Id Roominglist',
			'id_bloqueo' => 'Id Bloqueo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_log',$this->id_log);
		$criteria->compare('movimiento',$this->Movimiento,true);
		$criteria->compare('valores',$this->valores,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_roominglist',$this->id_roominglist);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}