<?php

/**
 * This is the model class for table "{{roominglist_desglose}}".
 *
 * The followings are the available columns in table '{{roominglist_desglose}}':
 * @property integer $id_pax
 * @property integer $id_agencia
 * @property integer $id_roominglist
 * @property string $nombre
 * @property string $Apellido
 * @property integer $edad
 * @property string $tipo
 * @property double $Importe
 */
class RoominglistDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RoominglistDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{roominglist_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_roominglist, nombre, tipo', 'required'),
			array('id_agencia, id_roominglist, edad', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('nombre', 'length', 'max'=>50),
			array('apellido', 'length', 'max'=>155),
			array('tipo', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_pax, id_agencia, id_roominglist, nombre, Apellido, edad, tipo, Importe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pax' => 'Id Pax',
			'id_agencia' => 'Id Agencia',
			'id_roominglist' => 'Id Roominglist',
			'nombre' => 'Nombre',
			'apellido' => 'Apellido',
			'edad' => 'Edad',
			'tipo' => 'Tipo',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pax',$this->id_pax);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_roominglist',$this->id_roominglist);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('apellido',$this->Apellido,true);
		$criteria->compare('edad',$this->edad);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('importe',$this->Importe);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}