<?php

/**
 * This is the model class for table "{{reservacion}}".
 *
 * The followings are the available columns in table '{{reservacion}}':
 * @property string $id_reservacion
 * @property integer $id_agencia
 * @property string $id_hotel
 * @property integer $id_usuario
 * @property integer $id_agente
 * @property integer $id_bloqueo
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property string $fecha_limite
 * @property string $fecha_limite_old
 * @property string $fecha_limite_h
 * @property string $fecha_liberacion
 * @property integer $usuario_liberacion
 * @property string $num_noches
 * @property string $observaciones
 * @property string $estatus
 * @property string $log
 * @property double $subtotal
 * @property double $comision
 * @property double $iva
 * @property double $tipo_cambio
 * @property double $total
 * @property double $total_tc
 * @property double $saldo
 * @property double $saldo_h
 * @property double $tarifa_neta
 * @property double $tarifa_agencia
 * @property double $porc_com_agencia
 * @property string $num_habitaciones
 * @property string $nombre_cliente
 * @property string $apellido_cliente
 * @property string $tel_cliente
 * @property string $id_tarifa
 * @property string $code
 * @property string $factura
 * @property integer $libera_cupon
 * @property integer $id_tipo_plan
 * @property double $comision_bancaria
 * @property string $motivo
 * @property integer $manual
 * @property string $politicas_cancelacion
 * @property string $desglose_rate
 * @property integer $enviado_h
 * @property integer $fecha_verificada
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 * @property Tarifa $idTarifa
 * @property ReservacionDesglose[] $reservacionDesgloses
 * @property ReservacionDesglosePersona[] $reservacionDesglosePersonas
 * @property SolicitudCancelacion[] $solicitudCancelacions
 */
class ReservacionRest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ReservacionRest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{reservacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, id_hotel, id_usuario, fecha_inicial, fecha_final, num_noches, estatus, log, subtotal, comision, iva, total, total_tc, saldo, saldo_h, tarifa_neta, tarifa_agencia, num_habitaciones, nombre_cliente, apellido_cliente, tel_cliente, desglose_rate', 'required'),
			array('id_agencia, id_usuario, id_agente, id_bloqueo, usuario_liberacion, libera_cupon, id_tipo_plan, manual, enviado_h, fecha_verificada', 'numerical', 'integerOnly'=>true),
			array('subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, saldo_h, tarifa_neta, tarifa_agencia, porc_com_agencia, comision_bancaria', 'numerical'),
			array('id_hotel', 'length', 'max'=>11),
			array('num_noches, num_habitaciones, id_tarifa', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>3),
			array('nombre_cliente, apellido_cliente, code, factura, motivo', 'length', 'max'=>255),
			array('tel_cliente', 'length', 'max'=>45),
			array('fecha_limite, fecha_limite_old, fecha_limite_h, fecha_liberacion, observaciones, politicas_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_reservacion, id_agencia, id_hotel, id_usuario, id_agente, id_bloqueo, fecha_inicial, fecha_final, fecha_limite, fecha_limite_old, fecha_limite_h, fecha_liberacion, usuario_liberacion, num_noches, observaciones, estatus, log, subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, saldo_h, tarifa_neta, tarifa_agencia, porc_com_agencia, num_habitaciones, nombre_cliente, apellido_cliente, tel_cliente, id_tarifa, code, factura, libera_cupon, id_tipo_plan, comision_bancaria, motivo, manual, politicas_cancelacion, desglose_rate, enviado_h, fecha_verificada', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
			'reservacionDesgloses' => array(self::HAS_MANY, 'ReservacionDesglose', 'id_reservacion'),
			'reservacionDesglosePersonas' => array(self::HAS_MANY, 'ReservacionDesglosePersona', 'id_reservacion'),
			'solicitudCancelacions' => array(self::HAS_MANY, 'SolicitudCancelacion', 'id_reserva'),
			'Recibosdetalle'=> array(self::HAS_MANY, 'ReciboDetalles', 'id_reservacion','condition'=>'Recibosdetalle.tipo=""'),
			'OrdenPagoDetalle'=> array(self::HAS_MANY, 'OrdenPagoDetalles', 'identificador','with'=>'idOrdenPago','condition'=>'OrdenPagoDetalle.tipo_producto="Reservacion" AND idOrdenPago.estatus="PA"'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 *i/
	pi ublic function attributeLabels()
	{
		return array(
			'id_reservacion' => 'Id Reservacion',
			'id_agencia' => 'Id Agencia',
			'id_hotel' => 'Id Hotel',
			'id_usuario' => 'Id Usuario',
			'id_agente' => 'Id Agente',
			'id_bloqueo' => 'Id Bloqueo',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'fecha_limite' => 'Fecha Limite',
			'fecha_limite_old' => 'Fecha Limite Old',
			'fecha_limite_h' => 'Fecha Limite H',
			'fecha_liberacion' => 'Fecha Liberacion',
			'usuario_liberacion' => 'Usuario Liberacion',
			'num_noches' => 'Num Noches',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'subtotal' => 'Subtotal',
			'comision' => 'Comision',
			'iva' => 'Iva',
			'tipo_cambio' => 'Tipo Cambio',
			'total' => 'Total',
			'total_tc' => 'Total Tc',
			'saldo' => 'Saldo',
			'saldo_h' => 'Saldo H',
			'tarifa_neta' => 'Tarifa Neta',
			'tarifa_agencia' => 'Tarifa Agencia',
			'porc_com_agencia' => 'Porc Com Agencia',
			'num_habitaciones' => 'Num Habitaciones',
			'nombre_cliente' => 'Nombre Cliente',
			'apellido_cliente' => 'Apellido Cliente',
			'tel_cliente' => 'Tel Cliente',
			'id_tarifa' => 'Id Tarifa',
			'code' => 'Code',
			'factura' => 'Factura',
			'libera_cupon' => 'Libera Cupon',
			'id_tipo_plan' => 'Id Tipo Plan',
			'comision_bancaria' => 'Comision Bancaria',
			'motivo' => 'Motivo',
			'manual' => 'Manual',
			'politicas_cancelacion' => 'Politicas Cancelacion',
			'desglose_rate' => 'Desglose Rate',
			'enviado_h' => 'Enviado H',
			'fecha_verificada' => 'Fecha Verificada',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agente',$this->id_agente);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('fecha_limite_old',$this->fecha_limite_old,true);
		$criteria->compare('fecha_limite_h',$this->fecha_limite_h,true);
		$criteria->compare('fecha_liberacion',$this->fecha_liberacion,true);
		$criteria->compare('usuario_liberacion',$this->usuario_liberacion);
		$criteria->compare('num_noches',$this->num_noches,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('tipo_cambio',$this->tipo_cambio);
		$criteria->compare('total',$this->total);
		$criteria->compare('total_tc',$this->total_tc);
		$criteria->compare('saldo',$this->saldo);
		$criteria->compare('saldo_h',$this->saldo_h);
		$criteria->compare('tarifa_neta',$this->tarifa_neta);
		$criteria->compare('tarifa_agencia',$this->tarifa_agencia);
		$criteria->compare('porc_com_agencia',$this->porc_com_agencia);
		$criteria->compare('num_habitaciones',$this->num_habitaciones,true);
		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);
		$criteria->compare('apellido_cliente',$this->apellido_cliente,true);
		$criteria->compare('tel_cliente',$this->tel_cliente,true);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('factura',$this->factura,true);
		$criteria->compare('libera_cupon',$this->libera_cupon);
		$criteria->compare('id_tipo_plan',$this->id_tipo_plan);
		$criteria->compare('comision_bancaria',$this->comision_bancaria);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('manual',$this->manual);
		$criteria->compare('politicas_cancelacion',$this->politicas_cancelacion,true);
		$criteria->compare('desglose_rate',$this->desglose_rate,true);
		$criteria->compare('enviado_h',$this->enviado_h);
		$criteria->compare('fecha_verificada',$this->fecha_verificada);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}