<?php



/**

 * This is the model class for table "{{reservacion}}".

 *

 * The followings are the available columns in table '{{reservacion}}':

 * @property string $id_reservacion

 * @property integer $id_agencia

 * @property string $id_hotel

 * @property integer $id_usuario

 * @property integer $id_agente

 * @property string $fecha_inicial

 * @property string $fecha_final

 * @property string $num_noches

 * @property string $observaciones

 * @property string $estatus

 * @property string $log

 * @property double $subtotal

 * @property double $comision

 * @property double $iva

 * @property double $total

 * @property double $saldo

 * @property double $porc_com_agencia

 * @property string $num_habitaciones

 * @property string $nombre_cliente

 * @property string $tel_cliente

 * @property string $id_tarifa

 * @property string $code

 * @property string $factura

 * @property integer $libera_cupon

 * @property integer $id_tipo_plan

 * @property double $comision_bancaria

 *

 * The followings are the available model relations:

 * @property Cuentas[] $cuentases

 * @property Hoteles $idHotel

 */

class Reservacion extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Reservacion the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{reservacion}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_agencia, id_hotel, id_usuario, fecha_inicial, fecha_final, num_noches, estatus, total, total_tc, saldo, num_habitaciones, nombre_cliente', 'required'),

			array('id_agencia, id_usuario, id_agente, id_bloqueo, usuario_liberacion, libera_cupon, id_tipo_plan, manual,enviado_h', 'numerical', 'integerOnly'=>true),

			array('subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, tarifa_neta, tarifa_agencia, saldo_h, porc_com_agencia, comision_bancaria', 'numerical'),

			array('id_hotel, num_noches, num_habitaciones, id_tarifa', 'length', 'max'=>10),

			array('estatus', 'length', 'max'=>3),

			array('nombre_cliente, apellido_cliente, code, factura', 'length', 'max'=>255),

			array('tel_cliente', 'length', 'max'=>45),

			array('motivo', 'length', 'max'=>255),

			array('fecha_limite, fecha_limite_old, fecha_limite_h, observaciones, politicas_cancelacion', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_reservacion, id_agencia, id_hotel, id_usuario, id_agente, id_bloqueo, fecha_inicial, fecha_final, fecha_limite, fecha_limite_old, fecha_limite_h, num_noches, observaciones, estatus, log, subtotal, comision, iva, tipo_cambio, total, total_tc, saldo, porc_com_agencia, num_habitaciones, nombre_cliente, apellido_cliente, tel_cliente, id_tarifa, code, factura, libera_cupon, id_tipo_plan, comision_bancaria, desglose_rate,enviado_h', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'cuentases' => array(self::HAS_MANY, 'Cuentas', 'id_reservacion'),

			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),			

			'idTipoPlan' => array(self::BELONGS_TO, 'Plan', 'id_tipo_plan'),

			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),

			'idAgente' => array(self::BELONGS_TO, 'Usuarios', 'id_agente'),

			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),

			'idUserLibera' => array(self::BELONGS_TO, 'Usuarios', 'usuario_liberacion'),

			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),

			'hotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

			'desglose' =>array(self::BELONGS_TO, 'ReservacionDesglose', 'id_reservacion'),


		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_reservacion' => 'Reservación',

			'id_agencia' => 'Agencia',

			'id_hotel' => 'Hotel',

			'id_usuario' => 'Usuario',

			'id_agente' => 'Agente',

			'id_bloqueo' => 'Bloqueo',

			'fecha_inicial' => 'Entrada',

			'fecha_final' => 'Salida',

			'fecha_limite' => 'Fecha Límite',

			'fecha_limite_old' => 'Fecha Límite Anterior',

			'fecha_limite_h' => 'Fecha Límite Hotel',

			'fecha_liberacion' => 'Fecha Liberación',

			'usuario_liberacion' => 'Liberó',

			'num_noches' => 'Noches',

			'observaciones' => 'Observaciones',

			'estatus' => 'Estatus',

			'log' => 'Log',

			'subtotal' => 'Subtotal',

			'comision' => 'Comisión',

			'iva' => 'Iva',

			'tipo_cambio' => 'Tipo de Cambio',

			'total' => 'Tarifa Pública',

			'total_tc' => 'Total TC',

			'saldo' => 'Saldo',

			'saldo_h'=> 'Saldo',

			'porc_com_agencia' => 'Porc Com Agencia',

			'num_habitaciones' => 'Habs.',

			'nombre_cliente' => 'Nombre Cliente',

			'apellido_cliente' => 'Apellido Cliente',

			'tel_cliente' => 'Teléfono',

			'id_tarifa' => 'Id Tarifa',

			'code' => 'Code',

			'factura' => 'Factura',

			'libera_cupon' => 'Libera Cupon',

			'id_tipo_plan' => 'Plan',

			'comision_bancaria' => 'Comisión Bancaria',

			'motivo' => 'Motivo de Cancelación',

			'manual' => 'Manual',

			'politicas_cancelacion' => 'Políticas de Cancelación',

			'desglose_rate'=> 'Desglose Comentarios y Promociones de la Tarifa ',
			
			'tarifa_neta'=> 'tarifa_neta',
			
			'tarifa_agencia'=> 'tarifa_agencia'


		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_reservacion',$this->id_reservacion,true);

		$criteria->compare('id_agencia',$this->id_agencia);

		$criteria->compare('id_hotel',$this->id_hotel,true);

		$criteria->compare('id_usuario',$this->id_usuario);

		$criteria->compare('id_agente',$this->id_agente);

		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);

		$criteria->compare('fecha_final',$this->fecha_final,true);

		$criteria->compare('num_noches',$this->num_noches,true);

		$criteria->compare('observaciones',$this->observaciones,true);

		$criteria->compare('estatus',$this->estatus,true);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('subtotal',$this->subtotal);

		$criteria->compare('comision',$this->comision);

		$criteria->compare('iva',$this->iva);

		$criteria->compare('tipo_cambio',$this->tipo_cambio);

		$criteria->compare('total',$this->total);

		$criteria->compare('total_tc',$this->total_tc);

		$criteria->compare('saldo',$this->saldo);

		$criteria->compare('porc_com_agencia',$this->porc_com_agencia);

		$criteria->compare('num_habitaciones',$this->num_habitaciones,true);

		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);

		$criteria->compare('apellido_cliente',$this->apellido_cliente,true);

		$criteria->compare('tel_cliente',$this->tel_cliente,true);

		$criteria->compare('id_tarifa',$this->id_tarifa,true);

		$criteria->compare('code',$this->code,true);

		$criteria->compare('factura',$this->factura,true);

		$criteria->compare('libera_cupon',$this->libera_cupon);

		$criteria->compare('id_tipo_plan',$this->id_tipo_plan);

		$criteria->compare('comision_bancaria',$this->comision_bancaria);

		$criteria->compare('desglose_rate',$this->desglose_rate);
		
		$criteria->compare('enviado_h',$this->enviado_h);


		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

	

	public function tipoCambio($precio)

	{	

		if(!empty($this->tipo_cambio) && $this->total > $this->total_tc){

			$precio = round($precio * $this->tipo_cambio,2);

		}

		

		return $precio;

	}

}