<?php

/**
 * This is the model class for table "{{recibos}}".
 *
 * The followings are the available columns in table '{{recibos}}':
 * @property integer $id_recibo
 * @property integer $id_usuario
 * @property integer $id_reservacion
 * @property integer $id_agencia
 * @property string $estatus
 * @property string $log
 * @property integer $liberado
 * @property string $forma_pago
 *
 * The followings are the available model relations:
 * @property Cuentas[] $cuentases
 * @property InfoPagos[] $infoPagoses
 */
class Recibos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Recibos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{recibos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, id_reservacion, id_agencia, log', 'required'),
			array('id_usuario, id_reservacion, id_agencia, liberado', 'numerical', 'integerOnly'=>true),
			array('estatus', 'length', 'max'=>4),
			array('forma_pago', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_recibo, id_usuario, id_reservacion, id_agencia, estatus, log, liberado, forma_pago', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cuentases' => array(self::HAS_MANY, 'Cuentas', 'id_recibo'),
			'infoPagoses' => array(self::HAS_MANY, 'InfoPagos', 'id_recibo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_recibo' => 'Id Recibo',
			'id_usuario' => 'Id Usuario',
			'id_reservacion' => 'Id Reservacion',
			'id_agencia' => 'Id Agencia',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'liberado' => 'Liberado',
			'forma_pago' => 'Forma Pago',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_reservacion',$this->id_reservacion);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('liberado',$this->liberado);
		$criteria->compare('forma_pago',$this->forma_pago,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}