<?php

/**
 * This is the model class for table "{{promociones_conectividad}}".
 *
 * The followings are the available columns in table '{{promociones_conectividad}}':
 * @property integer $id_promociones_conectividad
 * @property integer $id_hotel
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property string $fecha_inicio_precompra
 * @property string $fecha_final_precompra
 * @property string $info_json
 * @property integer $id_usuario
 * @property integer $estatus
 * @property string $log
 */
class PromocionesConectividad extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PromocionesConectividad the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{promociones_conectividad}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, fecha_final, fecha_inicio_precompra, fecha_final_precompra, info_json, id_usuario', 'required'),
			array('id_hotel, id_usuario, estatus', 'numerical', 'integerOnly'=>true),
			array('fecha_inicial', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_promociones_conectividad, id_hotel, fecha_inicial, fecha_final, fecha_inicio_precompra, fecha_final_precompra, info_json, id_usuario, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_promociones_conectividad' => 'Id Promociones Conectividad',
			'id_hotel' => 'Id Hotel',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'fecha_inicio_precompra' => 'Fecha Inicio Precompra',
			'fecha_final_precompra' => 'Fecha Final Precompra',
			'info_json' => 'Info Json',
			'id_usuario' => 'Id Usuario',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_promociones_conectividad',$this->id_promociones_conectividad);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('fecha_inicio_precompra',$this->fecha_inicio_precompra,true);
		$criteria->compare('fecha_final_precompra',$this->fecha_final_precompra,true);
		$criteria->compare('info_json',$this->info_json,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}