<?php

/**
 * This is the model class for table "{{promocion_junior}}".
 *
 * The followings are the available columns in table '{{promocion_junior}}':
 * @property integer $id_promocion_junior
 * @property integer $id_bloqueo
 * @property integer $id_tarifa
 * @property integer $id_usuario
 * @property integer $estatus
 * @property string $log
 * @property double $precio
 */
class PromocionJunior extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PromocionJunior the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{promocion_junior}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_bloqueo, id_tarifa, id_usuario', 'numerical', 'integerOnly'=>true),
			array('precio', 'numerical'),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_promocion_junior, id_bloqueo, id_tarifa, id_usuario, estatus, log, precio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_promocion_junior' => 'Id Promocion Junior',
			'id_bloqueo' => 'Id Bloqueo',
			'id_tarifa' => 'Id Tarifa',
			'id_usuario' => 'Id Usuario',
			'estatus' => 'Estatus',
			'log' => 'Log',
			'precio' => 'Precio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_promocion_junior',$this->id_promocion_junior);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('id_tarifa',$this->id_tarifa);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('precio',$this->precio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}