<?php

/**
 * This is the model class for table "{{plan_hotel}}".
 *
 * The followings are the available columns in table '{{plan_hotel}}':
 * @property integer $id_plan_hotel
 * @property integer $id_plan
 * @property string $id_hotel
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 * @property Plan $idPlan
 */
class PlanHotel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PlanHotel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{plan_hotel}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_plan, id_hotel', 'required'),
			array('id_plan', 'numerical', 'integerOnly'=>true),
			array('id_hotel', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_plan_hotel, id_plan, id_hotel', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idPlan' => array(self::BELONGS_TO, 'Plan', 'id_plan'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_plan_hotel' => 'Id Plan Hotel',
			'id_plan' => 'Id Plan',
			'id_hotel' => 'Id Hotel',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_plan_hotel',$this->id_plan_hotel);
		$criteria->compare('id_plan',$this->id_plan);
		$criteria->compare('id_hotel',$this->id_hotel,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}