<?php



/**

 * This is the model class for table "{{paquetes_boda}}".

 *

 * The followings are the available columns in table '{{paquetes_boda}}':

 * @property integer $id_paquete

 * @property string $nombre

 * @property string $info

 * @property string $descripcion

 * @property double $precio

 * @property string $id_hotel

 *

 * The followings are the available model relations:

 * @property Hoteles $idHotel

 */

class PaquetesBoda extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return PaquetesBoda the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{paquetes_boda}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(
			array('nombre, info, descripcion, precio, id_hotel', 'required'),
			array('comisionable, comision_hotel, comision_agencia, visibilidad', 'numerical', 'integerOnly'=>true),
			array('precio', 'numerical'),
			array('nombre', 'length', 'max'=>150),
			array('descripcion', 'length', 'max'=>250),
			array('id_hotel', 'length', 'max'=>10),
			array('fecha_vigencia', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_paquete, nombre, info, descripcion, precio,id_hotel, comisionable, comision_hotel, comision_agencia, fecha_vigencia, visibilidad', 'safe', 'on'=>'search'),
		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_paquete' => 'Id Paquete',

			'nombre' => 'Paquete',

			'info' => 'Descripción Larga',

			'descripcion' => 'Descripción Corta',

			'precio' => 'Precio',

			'id_hotel' => 'Hotel',
			'comisionable' => 'Comisionable',
			'comision_hotel' => 'Comision Hotel',
			'comision_agencia' => 'Comision Agencia',
			'fecha_vigencia' => 'Fecha Vigencia',
			'visibilidad' => 'Visibilidad',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_paquete',$this->id_paquete);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('info',$this->info,true);

		$criteria->compare('descripcion',$this->descripcion,true);

		$criteria->compare('precio',$this->precio);

		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('comisionable',$this->comisionable);
		$criteria->compare('comision_hotel',$this->comision_hotel);
		$criteria->compare('comision_agencia',$this->comision_agencia);
		$criteria->compare('fecha_vigencia',$this->fecha_vigencia,true);
		$criteria->compare('visibilidad',$this->visibilidad);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}