<?php

/**
 * This is the model class for table "{{outlet_hotel}}".
 *
 * The followings are the available columns in table '{{outlet_hotel}}':
 * @property integer $id_outlet_hotel
 * @property integer $id_hotel
 * @property integer $id_evento
 */
class OutletHotel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OutletHotel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{outlet_hotel}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, id_evento', 'required'),
			array('id_hotel, id_evento, estatus', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_outlet_hotel, id_hotel, id_evento', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_outlet_hotel' => 'Id Outlet Hotel',
			'id_hotel' => 'Id Hotel',
			'id_evento' => 'Id Evento',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_outlet_hotel',$this->id_outlet_hotel);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('id_evento',$this->id_evento);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}