<?php

/**
 * This is the model class for table "{{outlet_agencia}}".
 *
 * The followings are the available columns in table '{{outlet_agencia}}':
 * @property integer $id_agencia_outlet
 * @property integer $id_evento
 * @property integer $id_agencia
 */
class OutletAgencia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OutletAgencia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{outlet_agencia}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_evento, id_agencia', 'required'),
			array('id_evento, id_agencia', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_agencia_outlet, id_evento, id_agencia', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_agencia_outlet' => 'Id Agencia Outlet',
			'id_evento' => 'Id Evento',
			'id_agencia' => 'Id Agencia',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_agencia_outlet',$this->id_agencia_outlet);
		$criteria->compare('id_evento',$this->id_evento);
		$criteria->compare('id_agencia',$this->id_agencia);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}