<?php

/**
 * This is the model class for table "{{outlet}}".
 *
 * The followings are the available columns in table '{{outlet}}':
 * @property integer $id_outlet
 * @property string $comision_agencia
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $mensaje_comision_agencia
 * @property string $estatus
 */
class Outlet extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Outlet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{outlet}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, comision_agencia, fecha_inicio, fecha_final, mensaje_comision_agencia, estatus', 'required'),
			array('comision_agencia, solo_agencias', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_outlet, descripcion, comision_agencia, fecha_inicio, fecha_final, estatus, mensaje_comision_agencia, solo_agencias', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'Agencias' => array(self::BELONGS_TO, 'OutletAgencia', '', 'foreignKey' => array('id_outlet'=>'id_evento'))
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_outlet' => 'Id Outlet',
			'descripcion' => 'Descripción',
			'comision_agencia' => 'Comision Agencia',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'mensaje_comision_agencia' => 'Mensaje Comision Agencia',
			'solo_agencias' => 'Solo Agencias Participantes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_outlet',$this->id_outlet);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('comision_agencia',$this->comision_agencia,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('mensaje_comision_agencia',$this->mensaje_comision_agencia,true);
		$criteria->compare('solo_agencias',$this->solo_agencias,true);
		$criteria->compare('estatus',$this->estatus,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}