<?php

/**
 * This is the model class for table "{{orden_transporte}}".
 *
 * The followings are the available columns in table '{{orden_transporte}}':
 * @property integer $id
 * @property integer $id_servicio
 * @property integer $id_vehiculo
 * @property integer $id_chofer
 *
 * The followings are the available model relations:
 * @property Chofer $idChofer
 * @property CatServicios $idServicio
 * @property Vehiculo $idVehiculo
 */
class OrdenTransporte extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenTransporte the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{orden_transporte}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_servicio, id_vehiculo, id_chofer', 'required'),
			array('id_servicio, id_vehiculo, id_chofer', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_servicio, id_vehiculo, id_chofer', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idChofer' => array(self::BELONGS_TO, 'Chofer', 'id_chofer'),
			'idServicio' => array(self::BELONGS_TO, 'CatServicios', 'id_servicio'),
			'idVehiculo' => array(self::BELONGS_TO, 'Vehiculo', 'id_vehiculo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_servicio' => 'Id Servicio',
			'id_vehiculo' => 'Id Vehiculo',
			'id_chofer' => 'Id Chofer',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_servicio',$this->id_servicio);
		$criteria->compare('id_vehiculo',$this->id_vehiculo);
		$criteria->compare('id_chofer',$this->id_chofer);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}