<?php

/**
 * This is the model class for table "{{orden_pago}}".
 *
 * The followings are the available columns in table '{{orden_pago}}':
 * @property integer $id_orden_pago
 * @property string $id_usuario
 * @property integer $id_agencia
 * @property string $log
 * @property double $importe_total
 * @property string $observaciones
 * @property string $estatus
 * @property string $motivo_cancelacion
 *
 * The followings are the available model relations:
 * @property ComprobantesPago[] $comprobantesPagos
 * @property Agencias $idAgencia
 * @property Usuarios $idUsuario
 * @property OrdenPagoDetalles[] $ordenPagoDetalles
 */
class OrdenPago extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{orden_pago}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, id_agencia, importe_total, estatus', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('importe_total', 'numerical'),
			array('id_usuario', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>2),
			array('observaciones, motivo_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_orden_pago, id_usuario, id_agencia, log, importe_total, observaciones, estatus, motivo_cancelacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'comprobantesPagos' => array(self::HAS_MANY, 'ComprobantesPago', 'id_orden_pago'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'idPoliza' => array(self::BELONGS_TO, 'ContPoliza', 'id_poliza'),
			'ordenPagoDetalles' => array(self::HAS_MANY, 'OrdenPagoDetalles', 'id_orden_pago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_orden_pago' => 'Id Orden Pago',
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'log' => 'Log',
			'importe_total' => 'Importe Total',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'motivo_cancelacion' => 'Motivo Cancelacion',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_orden_pago',$this->id_orden_pago);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('importe_total',$this->importe_total);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('motivo_cancelacion',$this->motivo_cancelacion,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}