<?php

/**
 * This is the model class for table "{{orden_compra_detalles}}".
 *
 * The followings are the available columns in table '{{orden_compra_detalles}}':
 * @property integer $id_orden_compra_detalles
 * @property integer $id_orden_compra
 * @property string $tipo_producto
 * @property string $identificador
 * @property string $descripcion
 * @property double $importe
 */
class OrdenCompraDetalles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenCompraDetalles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{orden_compra_detalles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_orden_compra, tipo_producto, identificador, importe', 'required'),
			array('id_orden_compra', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('tipo_producto, identificador', 'length', 'max'=>100),
			array('descripcion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_orden_compra_detalles, id_orden_compra, tipo_producto, identificador, descripcion, importe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idOrdenCompra' => array(self::BELONGS_TO, 'OrdenCompra', 'id_orden_compra'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_orden_compra_detalles' => 'Id Orden Compra Detalles',
			'id_orden_compra' => 'Id Orden Compra',
			'tipo_producto' => 'Tipo Producto',
			'identificador' => 'Identificador',
			'descripcion' => 'Descripcion',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_orden_compra_detalles',$this->id_orden_compra_detalles);
		$criteria->compare('id_orden_compra',$this->id_orden_compra);
		$criteria->compare('tipo_producto',$this->tipo_producto,true);
		$criteria->compare('identificador',$this->identificador,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('importe',$this->importe);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}