<?php

/**
 * This is the model class for table "{{orden_compra}}".
 *
 * The followings are the available columns in table '{{orden_compra}}':
 * @property integer $id_orden_compra
 * @property string $id_usuario
 * @property integer $id_hotel
 * @property string $log
 * @property double $importe_total
 * @property string $observaciones
 * @property string $estatus
 * @property string $motivo_cancelacion
 * @property integer $id_poliza
 */
class OrdenCompra extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenCompra the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{orden_compra}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, importe_total, estatus', 'required'),
			array('id_hotel, id_poliza', 'numerical', 'integerOnly'=>true),
			array('importe_total', 'numerical'),
			array('id_usuario', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>2),
			array('observaciones, motivo_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_orden_compra, id_usuario, id_hotel, log, importe_total, observaciones, estatus, motivo_cancelacion, id_poliza', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'comprobantesPagos' => array(self::HAS_MANY, 'ComprobantesPago', 'id_orden_compra'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'idPoliza' => array(self::BELONGS_TO, 'ContPoliza', 'id_poliza'),
			'ordenCompraDetalles' => array(self::HAS_MANY, 'OrdenCompraDetalles', 'id_orden_compra'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_orden_compra' => 'Id Orden Pago',
			'id_usuario' => 'Id Usuario',
			'id_hotel' => 'Id Hotel',
			'log' => 'Log',
			'importe_total' => 'Importe Total',
			'observaciones' => 'Observaciones',
			'estatus' => 'Estatus',
			'motivo_cancelacion' => 'Motivo Cancelacion',
			'id_poliza' => 'Id Poliza',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_orden_compra',$this->id_orden_compra);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('importe_total',$this->importe_total);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('motivo_cancelacion',$this->motivo_cancelacion,true);
		$criteria->compare('id_poliza',$this->id_poliza);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}