<?php

/**
 * This is the model class for table "{{onboarding}}".
 *
 * The followings are the available columns in table '{{onboarding}}':
 * @property integer $id_onboarding
 * @property string $id_usuario
 * @property integer $omitir
 * @property integer $no_preguntar
 * @property integer $confirmado
 * @property integer $id_catalogo
 * @property string $log
 *
 * The followings are the available model relations:
 * @property CatalogoOnboarding $idCatalogo
 * @property Usuarios $idUsuario
 */
class Onboarding extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Onboarding the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{onboarding}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, id_catalogo', 'required'),
			array('omitir, no_preguntar, confirmado, id_catalogo', 'numerical', 'integerOnly'=>true),
			array('id_usuario', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_onboarding, id_usuario, omitir, no_preguntar, confirmado, id_catalogo, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCatalogo' => array(self::BELONGS_TO, 'CatalogoOnboarding', 'id_catalogo'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_onboarding' => 'Id Onboarding',
			'id_usuario' => 'Id Usuario',
			'omitir' => 'Omitir',
			'no_preguntar' => 'No Preguntar',
			'confirmado' => 'Confirmado',
			'id_catalogo' => 'Id Catalogo',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_onboarding',$this->id_onboarding);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('omitir',$this->omitir);
		$criteria->compare('no_preguntar',$this->no_preguntar);
		$criteria->compare('confirmado',$this->confirmado);
		$criteria->compare('id_catalogo',$this->id_catalogo);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}