<?php

/**
 * This is the model class for table "{{log_paypal}}".
 *
 * The followings are the available columns in table '{{log_paypal}}':
 * @property integer $id
 * @property string $estatus
 * @property string $request
 * @property string $response
 * @property string $key_rmt
 * @property string $referencia
 * @property string $reserva
 * @property string $tipo
 * @property string $key_paypal
 * @property string $log
 */
class LogPaypal extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LogPaypal the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{log_paypal}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('estatus, request, key_rmt, reserva, tipo, key_paypal, log', 'required'),
			array('estatus', 'length', 'max'=>100),
			array('key_rmt, referencia, tipo, key_paypal', 'length', 'max'=>50),
			array('response', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, estatus, request, response, key_rmt, referencia, reserva, tipo, key_paypal, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'estatus' => 'Estatus',
			'request' => 'Request',
			'response' => 'Response',
			'key_rmt' => 'Key Rmt',
			'referencia' => 'Referencia',
			'reserva' => 'Reserva',
			'tipo' => 'Tipo',
			'key_paypal' => 'Key Paypal',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('request',$this->request,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('key_rmt',$this->key_rmt,true);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('reserva',$this->reserva,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('key_paypal',$this->key_paypal,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}