<?php

/**
 * This is the model class for table "{{log_openpay}}".
 *
 * The followings are the available columns in table '{{log_openpay}}':
 * @property integer $id
 * @property integer $id_reservacion
 * @property integer $id_recibo
 * @property string $tipo
 * @property double $importe
 * @property string $request
 * @property string $response_liga
 * @property string $response_pago
 * @property string $estatus
 * @property integer $liga_generado
 * @property string $log
 * @property string $reference
 * @property string $id_factura
 *
 * The followings are the available model relations:
 * @property Recibo $idRecibo
 * @property FeFacturas $idFactura
 */
class LogOpenpay extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LogOpenpay the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{log_openpay}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, tipo, importe, estatus', 'required'),
			array('id_reservacion, id_recibo, id_agencia, liga_generado', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('tipo, transaction, referencia_banco, concepto_pago, clabe, estatus', 'length', 'max'=>100),
			array('reference', 'length', 'max'=>50),
			array('id_usuario, id_factura', 'length', 'max'=>10),
			array('fecha_limite, response_liga, response_pago', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_reservacion, id_recibo, id_usuario, id_agencia, tipo, importe, transaction, referencia_banco, fecha_limite, concepto_pago, clabe, request, response_liga, response_pago, estatus, liga_generado, log, reference, id_factura', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{ 
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idRecibo' => array(self::BELONGS_TO, 'Recibo', 'id_recibo'),
			'idNotaCredito' => array(self::BELONGS_TO, 'NotaCredito', 'id_recibo'),
			'idFactura' => array(self::BELONGS_TO, 'FeFacturas', 'id_factura'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_reservacion' => 'Id Reservacion',
			'id_recibo' => 'Id Recibo',
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'tipo' => 'Tipo',
			'importe' => 'Importe',
			'transaction' => 'Transaction',
			'referencia_banco' => 'Referencia Banco',
			'fecha_limite' => 'Fecha Limite',
			'concepto_pago' => 'Concepto Pago',
			'clabe' => 'Clabe',
			'request' => 'Request',
			'response_liga' => 'Response Liga',
			'response_pago' => 'Response Pago',
			'estatus' => 'Estatus',
			'liga_generado' => 'Liga Generado',
			'log' => 'Log',
			'reference' => 'Reference',
			'id_factura' => 'Id Factura',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_reservacion',$this->id_reservacion);
		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('transaction',$this->transaction,true);
		$criteria->compare('referencia_banco',$this->referencia_banco,true);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('concepto_pago',$this->concepto_pago,true);
		$criteria->compare('clabe',$this->clabe,true);
		$criteria->compare('request',$this->request,true);
		$criteria->compare('response_liga',$this->response_liga,true);
		$criteria->compare('response_pago',$this->response_pago,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('liga_generado',$this->liga_generado);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('id_factura',$this->id_factura,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}