<?php

/**
 * This is the model class for table "{{impuestos}}".
 *
 * The followings are the available columns in table '{{impuestos}}':
 * @property integer $id_impuesto
 * @property integer $iva
 * @property integer $impuesto_hospedaje
 */
class Impuestos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Impuestos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{impuestos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('iva, impuesto_hospedaje', 'required'),
			array('iva, impuesto_hospedaje', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_impuesto, iva, impuesto_hospedaje', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_impuesto' => 'Id Impuesto',
			'iva' => 'Iva',
			'impuesto_hospedaje' => 'Impuesto Hospedaje',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_impuesto',$this->id_impuesto);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('impuesto_hospedaje',$this->impuesto_hospedaje);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}