<?php

/**
 * This is the model class for table "{{guests_weddings}}".
 *
 * The followings are the available columns in table '{{guests_weddings}}':
 * @property integer $id_guests_weddings
 * @property string $nombre
 * @property string $apellidos
 * @property string $telefono
 * @property string $email
 * @property string $estatus
 * @property integer $envio_invitacion
 * @property integer $id_event_wedding
 * @property integer $id_roominglist
 *
 * The followings are the available model relations:
 * @property EventsWeddings $idEventWedding
 */
class GuestsWeddings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GuestsWeddings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{guests_weddings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, email, estatus, envio_invitacion, id_event_wedding', 'required'),
			array('envio_invitacion, id_event_wedding, id_roominglist', 'numerical', 'integerOnly'=>true),
			array('nombre, apellidos, email', 'length', 'max'=>50),
			array('telefono', 'length', 'max'=>20),
			array('estatus', 'length', 'max'=>3),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_guests_weddings, nombre, apellidos, telefono, email, estatus, envio_invitacion, id_event_wedding, id_roominglist', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idEventWedding' => array(self::BELONGS_TO, 'EventsWeddings', 'id_event_wedding'),
			'idRoominglist' => array(self::BELONGS_TO, 'Roominglist', 'id_roominglist'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_guests_weddings' => 'Id Guests Weddings',
			'nombre' => 'Nombre',
			'apellidos' => 'Apellidos',
			'telefono' => 'Telefono',
			'email' => 'Email',
			'estatus' => 'Estatus',
			'envio_invitacion' => 'Envio Invitacion',
			'id_event_wedding' => 'Id Event Wedding',
			'id_roominglist' => 'Id Roominglist',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_guests_weddings',$this->id_guests_weddings);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('apellidos',$this->apellidos,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('envio_invitacion',$this->envio_invitacion);
		$criteria->compare('id_event_wedding',$this->id_event_wedding);
		$criteria->compare('id_roominglist',$this->id_roominglist);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}