<?php

/**
 * This is the model class for table "{{grupos_tipos}}".
 *
 * The followings are the available columns in table '{{grupos_tipos}}':
 * @property string $id_grupos_tipos
 * @property string $nombre_tipo
 *
 * The followings are the available model relations:
 * @property GruposCotizaciones[] $gruposCotizaciones
 */
class GruposTipos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GruposTipos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos_tipos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_tipo', 'required'),
			array('nombre_tipo', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_grupos_tipos, nombre_tipo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'gruposCotizaciones' => array(self::HAS_MANY, 'GruposCotizaciones', 'id_grupos_tipos'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_grupos_tipos' => 'Id Grupos Tipos',
			'nombre_tipo' => 'Nombre Tipo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_grupos_tipos',$this->id_grupos_tipos,true);
		$criteria->compare('nombre_tipo',$this->nombre_tipo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}