<?php

/**
 * This is the model class for table "{{grupos_politicas_pagos}}".
 *
 * The followings are the available columns in table '{{grupos_politicas_pagos}}':
 * @property integer $id_politicas_pagos
 * @property string $id_bloqueo
 * @property integer $maximo_dias
 * @property string $condiciones_contrato_hotel
 * @property string $fecha_contratacion
 * @property string $fecha_limite_pago_hotel
 * @property string $penalidades
 *
 * The followings are the available model relations:
 * @property Bloqueos $idBloqueo
 * @property GruposPoliticasPagosDesglose[] $gruposPoliticasPagosDesgloses
 */
class GruposPoliticasPagos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GruposPoliticasPagos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos_politicas_pagos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_bloqueo', 'required'),
			array('maximo_dias, dias_antes, reduccion', 'numerical', 'integerOnly'=>true),
			array('id_bloqueo', 'length', 'max'=>10),
			array('condiciones_contrato_hotel, condiciones_cancelacion, checkOut, fecha_contratacion, fecha_limite_pago_hotel, penalidades', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_politicas_pagos, id_bloqueo, maximo_dias, condiciones_contrato_hotel, fecha_contratacion, fecha_limite_pago_hotel, penalidades, checkOut', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'gruposPoliticasPagosDesgloses' => array(self::HAS_MANY, 'GruposPoliticasPagosDesglose', 'id_politicas_pagos'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_politicas_pagos' => 'Id Políticas Pagos',
			'id_bloqueo' => 'Id Bloqueo',
			'maximo_dias' => 'Máximo Días',
			'condiciones_contrato_hotel' => 'Condiciones Contrato Hotel',
			'fecha_contratacion' => 'Fecha Contratación',
			'fecha_limite_pago_hotel' => 'Fecha Límite Pago Hotel',
			'penalidades' => 'Penalidades',
			'dias_antes' => 'Días antes de llegada',
			'reduccion' => 'Porcentaje de Reduccion',
			'condiciones_cancelacion' => 'Condiciones',
			'checkOut' => 'Check Out',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_politicas_pagos',$this->id_politicas_pagos);
		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);
		$criteria->compare('maximo_dias',$this->maximo_dias);
		$criteria->compare('condiciones_contrato_hotel',$this->condiciones_contrato_hotel,true);
		$criteria->compare('fecha_contratacion',$this->fecha_contratacion,true);
		$criteria->compare('fecha_limite_pago_hotel',$this->fecha_limite_pago_hotel,true);
		$criteria->compare('penalidades',$this->penalidades,true);
		$criteria->compare('dias_antes',$this->dias_antes,true);
		$criteria->compare('reduccion',$this->reduccion,true);
		$criteria->compare('condiciones_cancelacion',$this->condiciones_cancelacion,true);
		$criteria->compare('checkOut',$this->checkOut,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}