<?php

/**
 * This is the model class for table "{{flyers}}".
 *
 * The followings are the available columns in table '{{flyers}}':
 * @property integer $id_flyer
 * @property string $nombreimagen
 * @property string $id_hotel
 * @property integer $id_cadena_hotel
 * @property string $fechainicial
 * @property string $fechafinal
 * @property integer $id_tipo_promocion
 * @property string $titulo
 * @property string $tipo
 *
 * The followings are the available model relations:
 * @property LogoEventos $idTipoPromocion
 * @property CadenaHotel $idCadenaHotel
 * @property Hoteles $idHotel
 */
class Flyers extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Flyers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{flyers}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.

		return array(
			array('fechainicial, fechafinal, titulo', 'required'),
			array('id_cadena_hotel, id_tipo_promocion', 'numerical', 'integerOnly'=>true),
			array('nombreimagen', 'file', 'types'=>'jpg, gif, png', 'safe' => false, 'on'=>'create'),
			array('nombreimagen', 'file', 'allowEmpty'=>true, 'on' => 'update'),
			array('id_hotel', 'length', 'max'=>10),
			array('titulo', 'length', 'max'=>150),
			array('tipo','length','max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_flyer, nombreimagen, id_hotel, id_cadena_hotel, fechainicial, fechafinal, id_tipo_promocion, titulo, tipo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoPromocion' => array(self::BELONGS_TO, 'LogoEventos', 'id_tipo_promocion'),
			'idCadenaHotel' => array(self::BELONGS_TO, 'CadenaHotel', 'id_cadena_hotel'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'tipoFlyer' => array(self::BELONGS_TO, 'FlyersTipo', 'id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_flyer' => 'Id Flyer',
			'nombreimagen' => 'Cargar Imagen',
			'id_hotel' => 'Hotel',
			'id_cadena_hotel' => 'Cadena Hotel',
			'fechainicial' => 'Fecha Inicio',
			'fechafinal' => 'Fecha Final',
			'id_tipo_promocion' => 'Tipo Promoción',
			'titulo' => 'Titulo',
			'tipo_flyer'=>'Tipo Flyer',
			'tipo' => 'Tipo'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_flyer',$this->id_flyer);
		$criteria->compare('nombreimagen',$this->nombreimagen,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_cadena_hotel',$this->id_cadena_hotel);
		$criteria->compare('fechainicial',$this->fechainicial,true);
		$criteria->compare('fechafinal',$this->fechafinal,true);
		$criteria->compare('id_tipo_promocion',$this->id_tipo_promocion);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('tipo_flyer',$this->tipo_flyer,true);
	  	  $criteria->addCondition("fechafinal >= '".date("Y-m-d")."'");
			$criteria->order = 'fechafinal ASC';
	
		$criteria->compare('tipo',$this->tipo,true);



		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'pagination' => array(
					'pageSize' => 20,

				),
		));
	}
}