<?php

/**
 * This is the model class for table "{{filtros}}".
 *
 * The followings are the available columns in table '{{filtros}}':
 * @property integer $id_filtro
 * @property string $descripcion
 * @property integer $codigo_beds
 * @property string $log
 *
 * The followings are the available model relations:
 * @property FiltroHoteles[] $filtroHoteles
 */
class Filtros extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Filtros the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{filtros}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, log', 'required'),
			array('codigo_beds', 'numerical', 'integerOnly'=>true),
			array('descripcion', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_filtro, descripcion, codigo_beds, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'filtroHoteles' => array(self::HAS_MANY, 'FiltroHoteles', 'id_filtro'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_filtro' => 'Id Filtro',
			'descripcion' => 'Descripcion',
			'codigo_beds' => 'Codigo Beds',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_filtro',$this->id_filtro);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('codigo_beds',$this->codigo_beds);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}