<?php

/**
 * This is the model class for table "{{filtro_hoteles}}".
 *
 * The followings are the available columns in table '{{filtro_hoteles}}':
 * @property integer $id_filtro_hotel
 * @property integer $id_filtro
 * @property integer $id_hotel
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Filtros $idFiltro
 */
class FiltroHoteles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FiltroHoteles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{filtro_hoteles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_filtro, id_hotel, log', 'required'),
			array('id_filtro, id_hotel', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_filtro_hotel, id_filtro, id_hotel, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idFiltro' => array(self::BELONGS_TO, 'Filtros', 'id_filtro'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_filtro_hotel' => 'Id Filtro Hotel',
			'id_filtro' => 'Id Filtro',
			'id_hotel' => 'Id Hotel',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_filtro_hotel',$this->id_filtro_hotel);
		$criteria->compare('id_filtro',$this->id_filtro);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}