<?php

/**
 * This is the model class for table "{{fe_facturas_detalle}}".
 *
 * The followings are the available columns in table '{{fe_facturas_detalle}}':
 * @property string $id_factura_detalle
 * @property string $id_factura
 * @property string $cantidad
 * @property string $unidad
 * @property string $no_identificacion
 * @property integer $cve_prod_serv
 * @property string $descripcion
 * @property string $clave_unidad
 * @property double $valor_unitario
 * @property double $importe
 * @property integer $id_recibo
 */
class FeFacturasDetalle extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FeFacturasDetalle the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fe_facturas_detalle}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_factura, cantidad, descripcion, valor_unitario, importe, id_recibo', 'required'),
			array('cve_prod_serv, id_recibo', 'numerical', 'integerOnly'=>true),
			array('valor_unitario, importe', 'numerical'),
			array('id_factura, cantidad', 'length', 'max'=>10),
			array('unidad, no_identificacion', 'length', 'max'=>120),
			array('clave_unidad', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_factura_detalle, id_factura, cantidad, unidad, no_identificacion, cve_prod_serv, descripcion, clave_unidad, valor_unitario, importe, id_recibo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_factura_detalle' => 'Id Factura Detalle',
			'id_factura' => 'Id Factura',
			'cantidad' => 'Cantidad',
			'unidad' => 'Unidad',
			'no_identificacion' => 'No Identificacion',
			'cve_prod_serv' => 'Cve Prod Serv',
			'descripcion' => 'Descripcion',
			'clave_unidad' => 'Clave Unidad',
			'valor_unitario' => 'Valor Unitario',
			'importe' => 'Importe',
			'id_recibo' => 'Id Recibo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_factura_detalle',$this->id_factura_detalle,true);
		$criteria->compare('id_factura',$this->id_factura,true);
		$criteria->compare('cantidad',$this->cantidad,true);
		$criteria->compare('unidad',$this->unidad,true);
		$criteria->compare('no_identificacion',$this->no_identificacion,true);
		$criteria->compare('cve_prod_serv',$this->cve_prod_serv);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('clave_unidad',$this->clave_unidad,true);
		$criteria->compare('valor_unitario',$this->valor_unitario);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('id_recibo',$this->id_recibo);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}