<?php

/**
 * This is the model class for table "{{fe_factura_recibo}}".
 *
 * The followings are the available columns in table '{{fe_factura_recibo}}':
 * @property integer $id_factura_recibo
 * @property integer $id_factura
 * @property integer $id_recibo
 * @property string $uuid_certificacion
 * @property string $fecha_certificacion
 * @property string $descripcion
 * @property double $subtotal
 * @property double $iva
 * @property double $total
 * @property string $ruta_local_pdf
 * @property string $ruta_local_xml
 * @property integer $estatus
 * @property string $log
 */
class FeFacturaRecibo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FeFacturaRecibo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fe_factura_recibo}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_factura, id_recibo, descripcion, subtotal, iva, total, estatus', 'required'),
			array('id_factura, id_recibo, estatus', 'numerical', 'integerOnly'=>true),
			array('subtotal, iva, total', 'numerical'),
			array('folio', 'length', 'max'=>20),
			array('serie', 'length', 'max'=>5),
			array('uuid_certificacion, fecha_certificacion', 'length', 'max'=>100),
			array('descripcion', 'length', 'max'=>200),
			array('ruta_local_pdf, ruta_local_xml, response', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_factura_recibo, id_factura, id_recibo, folio, serie, uuid_certificacion, fecha_certificacion, descripcion, subtotal, iva, total, ruta_local_pdf, ruta_local_xml, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_factura_recibo' => 'Id Factura Recibo',
			'id_factura' => 'Id Factura',
			'id_recibo' => 'Id Recibo',
			'folio' => 'Folio',
			'serie' => 'Serie',
			'uuid_certificacion' => 'Uuid Certificacion',
			'fecha_certificacion' => 'Fecha Certificacion',
			'descripcion' => 'Descripcion',
			'subtotal' => 'Subtotal',
			'iva' => 'Iva',
			'total' => 'Total',
			'ruta_local_pdf' => 'Ruta Local Pdf',
			'ruta_local_xml' => 'Ruta Local Xml',
			'estatus' => 'Estatus',
			'response' => 'Response',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_factura_recibo',$this->id_factura_recibo);
		$criteria->compare('id_factura',$this->id_factura);
		$criteria->compare('id_recibo',$this->id_recibo);
		$criteria->compare('folio',$this->folio,true);
		$criteria->compare('serie',$this->serie,true);
		$criteria->compare('uuid_certificacion',$this->uuid_certificacion,true);
		$criteria->compare('fecha_certificacion',$this->fecha_certificacion,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('total',$this->total);
		$criteria->compare('ruta_local_pdf',$this->ruta_local_pdf,true);
		$criteria->compare('ruta_local_xml',$this->ruta_local_xml,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}