<?php

/**
 * This is the model class for table "{{events_weddings}}".
 *
 * The followings are the available columns in table '{{events_weddings}}':
 * @property integer $id_events_weddings
 * @property string $invitacion_text
 * @property string $invitacion_img
 * @property string $id_bloqueo
 *
 * The followings are the available model relations:
 * @property Bloqueos $idBloqueo
 * @property GuestsWeddings[] $guestsWeddings
 */
class EventsWeddings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventsWeddings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{events_weddings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invitacion_text, invitacion_img, id_bloqueo', 'required'),
			array('invitacion_img', 'length', 'max'=>50),
			array('id_bloqueo', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_events_weddings, invitacion_text, invitacion_img, id_bloqueo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'guestsWeddings' => array(self::HAS_MANY, 'GuestsWeddings', 'id_event_wedding'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_events_weddings' => 'Id Events Weddings',
			'invitacion_text' => 'Invitacion Text',
			'invitacion_img' => 'Invitacion Img',
			'id_bloqueo' => 'Id Bloqueo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_events_weddings',$this->id_events_weddings);
		$criteria->compare('invitacion_text',$this->invitacion_text,true);
		$criteria->compare('invitacion_img',$this->invitacion_img,true);
		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}