<?php

/**
 * This is the model class for table "{{events_guests}}".
 *
 * The followings are the available columns in table '{{events_guests}}':
 * @property integer $id_event_guest
 * @property integer $id_event
 * @property integer $id_invitado
 * @property integer $id_agencia
 * @property string $estatus
 * @property integer $confirmo
 * @property integer $asistio
 *
 * The followings are the available model relations:
 * @property Guests $idInvitado
 * @property Events $idEvent
 * @property Agencias $idAgencia
 */
class EventsGuests extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventsGuests the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{events_guests}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_event, confirmo, asistio', 'required'),
			array('id_event, id_invitado, id_agencia, confirmo, asistio', 'numerical', 'integerOnly'=>true),
			array('estatus', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_event_guest, id_event, id_invitado, id_agencia, estatus, confirmo, asistio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idInvitado' => array(self::BELONGS_TO, 'Guests', 'id_invitado'),
			'idEvent' => array(self::BELONGS_TO, 'Events', 'id_event'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_event_guest' => 'Id Event Guest',
			'id_event' => 'Id Event',
			'id_invitado' => 'Id Invitado',
			'id_agencia' => 'Id Agencia',
			'estatus' => 'Estatus',
			'confirmo' => 'Confirmo',
			'asistio' => 'Asistio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_event_guest',$this->id_event_guest);
		$criteria->compare('id_event',$this->id_event);
		$criteria->compare('id_invitado',$this->id_invitado);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('confirmo',$this->confirmo);
		$criteria->compare('asistio',$this->asistio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}