<?php

/**
 * This is the model class for table "destinations_do".
 *
 * The followings are the available columns in table 'destinations_do':
 * @property integer $id
 * @property integer $codigo
 * @property string $name
 * @property string $id_country
 * @property string $country
 * @property string $path_destination
 */
class DestinationsDo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DestinationsDo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'destinations_do';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('codigo, name, id_country, country, path_destination', 'required'),
			array('codigo', 'numerical', 'integerOnly'=>true),
			array('name, path_destination', 'length', 'max'=>255),
			array('id_country', 'length', 'max'=>10),
			array('country', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, codigo, name, id_country, country, path_destination', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'codigo' => 'Codigo',
			'name' => 'Name',
			'id_country' => 'Id Country',
			'country' => 'Country',
			'path_destination' => 'Path Destination',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('codigo',$this->codigo);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('id_country',$this->id_country,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('path_destination',$this->path_destination,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}