<?php

/**
 * This is the model class for table "{{cupones_agencias}}".
 *
 * The followings are the available columns in table '{{cupones_agencias}}':
 * @property integer $id_cupon
 * @property integer $id_agencia
 * @property string $codigo
 * @property string $id_reservacion
 * @property string $fecha_limite
 * @property integer $comision
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property Reservacion $idReservacion
 */
class CuponesAgencias extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CuponesAgencias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cupones_agencias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, codigo, fecha_limite', 'required'),
			array('id_agencia, comision', 'numerical', 'integerOnly'=>true),
			array('codigo', 'length', 'max'=>100),
			array('id_reservacion', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cupon, id_agencia, codigo, id_reservacion, fecha_limite, comision, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cupon' => 'Id Cupon',
			'id_agencia' => 'Id Agencia',
			'codigo' => 'Codigo',
			'id_reservacion' => 'Id Reservacion',
			'fecha_limite' => 'Fecha Limite',
			'comision' => 'Comision',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cupon',$this->id_cupon);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}