<?php

/**
 * This is the model class for table "{{cuenta}}".
 *
 * The followings are the available columns in table '{{cuenta}}':
 * @property integer $id_cuenta
 * @property integer $id_banco
 * @property string $descripcion
 * @property string $numero_cuenta
 * @property double $saldo
 *
 * The followings are the available model relations:
 * @property Banco $idBanco
 */
class Cuenta extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Cuenta the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cuenta}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_banco, descripcion, numero_cuenta, saldo', 'required'),
			array('id_banco', 'numerical', 'integerOnly'=>true),
			array('saldo', 'numerical'),
			array('descripcion, numero_cuenta, firma', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cuenta, id_banco, descripcion, numero_cuenta, saldo, firma', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBanco' => array(self::BELONGS_TO, 'Banco', 'id_banco'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cuenta' => 'Cuenta',
			'id_banco' => 'Banco',
			'descripcion' => 'Descripcion',
			'numero_cuenta' => 'Numero Cuenta',
			'saldo' => 'Saldo',
			'firma' => 'Firma',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('id_banco',$this->id_banco);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('numero_cuenta',$this->numero_cuenta,true);
		$criteria->compare('saldo',$this->saldo);
		$criteria->compare('firma',$this->firma,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}