<?php

/**
 * This is the model class for table "{{contratos_pagos}}".
 *
 * The followings are the available columns in table '{{contratos_pagos}}':
 * @property integer $id
 * @property integer $id_contrato
 * @property integer $id_tipo_pago
 * @property string $id_user
 * @property string $fecha
 * @property double $importe
 * @property string $estatus
 * @property string $motivo
 *
 * The followings are the available model relations:
 * @property Usuarios $idUser
 * @property ContratosBloqueos $idContrato
 * @property TipoPago $idTipoPago
 */
class ContratosPagos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ContratosPagos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contratos_pagos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_contrato, id_tipo_pago, id_user, importe', 'required'),
			array('id_contrato, id_tipo_pago', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('id_user', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>1),
			array('observaciones, motivo', 'safe'),
			array('comprobante', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_contrato, id_tipo_pago, id_user, fecha, importe, estatus, observaciones, motivo, comprobante', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_user'),
			'idContrato' => array(self::BELONGS_TO, 'ContratosBloqueos', 'id_contrato'),
			'idTipoPago' => array(self::BELONGS_TO, 'TipoPago', 'id_tipo_pago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_contrato' => 'Contrato',
			'id_tipo_pago' => 'Tipo de Pago',
			'id_user' => 'Usuario',
			'fecha' => 'Fecha',
			'importe' => 'Importe',
			'estatus' => 'Estatus',
			'observaciones' => 'Observaciones',
			'motivo' => 'Motivo',
			'comprobante' => 'Comprobante',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('id_tipo_pago',$this->id_tipo_pago);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('comprobante',$this->comprobante,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}