<?php

/**
 * This is the model class for table "{{contracts}}".
 *
 * The followings are the available columns in table '{{contracts}}':
 * @property integer $id_contract
 * @property integer $id_user_signed
 * @property integer $id_user_created
 * @property string $time
 * @property string $date
 * @property string $location
 * @property string $ip
 * @property string $status
 * @property string $created
 * @property string $id_bloqueo
 *
 * The followings are the available model relations:
 * @property Bloqueos $idBloqueo
 * @property Users $idUserSigned
 * @property Users $idUserCreated
 */
class Contracts extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Contracts the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contracts}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_user_created, status, created, id_bloqueo', 'required'),
			array('id_user_signed, id_user_created', 'numerical', 'integerOnly'=>true),
			array('location', 'length', 'max'=>70),
			array('ip', 'length', 'max'=>20),
			array('status', 'length', 'max'=>3),
			array('id_bloqueo', 'length', 'max'=>10),
			array('time, date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_contract, id_user_signed, id_user_created, time, date, location, ip, status, created, id_bloqueo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'idUserSigned' => array(self::BELONGS_TO, 'Users', 'id_user_signed'),
			'idUserCreated' => array(self::BELONGS_TO, 'Users', 'id_user_created'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_contract' => 'Id Contract',
			'id_user_signed' => 'Id User Signed',
			'id_user_created' => 'Id User Created',
			'time' => 'Time',
			'date' => 'Date',
			'location' => 'Location',
			'ip' => 'Ip',
			'status' => 'Status',
			'created' => 'Created',
			'id_bloqueo' => 'Id Bloqueo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_contract',$this->id_contract);
		$criteria->compare('id_user_signed',$this->id_user_signed);
		$criteria->compare('id_user_created',$this->id_user_created);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('ip',$this->ip,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}