<?php

/**
 * This is the model class for table "{{comprobantes_pago}}".
 *
 * The followings are the available columns in table '{{comprobantes_pago}}':
 * @property integer $id_comprobante_pago
 * @property integer $id_orden_pago
 * @property integer $id_tipo
 * @property string $cliente
 * @property string $referencia
 * @property integer $id_banco
 * @property integer $id_planpago
 * @property string $tarjeta
 * @property double $importe
 * @property string $log
 * @property integer $id_agencia
 * @property string $id_user
 * @property integer $id_cuenta
 * @property double $comision
 * @property string $estatus
 * @property string $observaciones
 * @property string $comprobante
 * @property string $motivo_cancelacion
 * @property integer $revisado
 * @property integer $facturado
 * @property integer $efectivo_facturable
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property Cuenta $idCuenta
 * @property OrdenPago $idOrdenPago
 * @property TipoPago $idTipoPago
 * @property Usuarios $idUser
 * @property PlanPago $idPlanpago
 * @property Banco $idBanco
 */
class ComprobantesPago extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ComprobantesPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comprobantes_pago}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tipo, importe, estatus, revisado, facturado, efectivo_facturable', 'required'),
			array('id_orden_pago, id_tipo, id_banco, id_planpago, id_agencia, id_cuenta, revisado, facturado, efectivo_facturable', 'numerical', 'integerOnly'=>true),
			array('importe, comision', 'numerical'),
			array('cliente, referencia', 'length', 'max'=>100),
			array('tarjeta', 'length', 'max'=>4),
			array('id_user', 'length', 'max'=>11),
			array('estatus', 'length', 'max'=>10),
			array('comprobante', 'length', 'max'=>255),
			array('observaciones, motivo_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_comprobante_pago, id_orden_pago, id_tipo, cliente, referencia, id_banco, id_planpago, tarjeta, importe, log, id_agencia, id_user, id_cuenta, comision, estatus, observaciones, comprobante, motivo_cancelacion, revisado, facturado, efectivo_facturable', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idCuenta' => array(self::BELONGS_TO, 'Cuenta', 'id_cuenta'),
			'idOrdenPago' => array(self::BELONGS_TO, 'OrdenPago', 'id_orden_pago'),
			'idTipo' => array(self::BELONGS_TO, 'TipoPago', 'id_tipo'),
			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_user'),
			'idPlanpago' => array(self::BELONGS_TO, 'PlanPago', 'id_planpago'),
			'idBanco' => array(self::BELONGS_TO, 'Banco', 'id_banco'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_comprobante_pago' => 'Id Comprobante Pago',
			'id_orden_pago' => 'Id Orden Pago',
			'id_tipo' => 'Id Tipo Pago',
			'cliente' => 'Cliente',
			'referencia' => 'Referencia',
			'id_banco' => 'Id Banco',
			'id_planpago' => 'Id Planpago',
			'tarjeta' => 'Tarjeta',
			'importe' => 'Importe',
			'log' => 'Log',
			'id_agencia' => 'Id Agencia',
			'id_user' => 'Id User',
			'id_cuenta' => 'Id Cuenta',
			'comision' => 'Comision',
			'estatus' => 'Estatus',
			'observaciones' => 'Observaciones',
			'comprobante' => 'Comprobante',
			'motivo_cancelacion' => 'Motivo Cancelacion',
			'revisado' => 'Revisado',
			'facturado' => 'Facturado',
			'efectivo_facturable' => 'Efectivo Facturable',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_comprobante_pago',$this->id_comprobante_pago);
		$criteria->compare('id_orden_pago',$this->id_orden_pago);
		$criteria->compare('id_tipo',$this->id_tipo);
		$criteria->compare('cliente',$this->cliente,true);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('id_banco',$this->id_banco);
		$criteria->compare('id_planpago',$this->id_planpago);
		$criteria->compare('tarjeta',$this->tarjeta,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('comprobante',$this->comprobante,true);
		$criteria->compare('motivo_cancelacion',$this->motivo_cancelacion,true);
		$criteria->compare('revisado',$this->revisado);
		$criteria->compare('facturado',$this->facturado);
		$criteria->compare('efectivo_facturable',$this->efectivo_facturable);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}