<?php

/**
 * This is the model class for table "{{comision}}".
 *
 * The followings are the available columns in table '{{comision}}':
 * @property integer $id_comision
 * @property integer $id_cuenta
 * @property integer $id_planpago
 * @property double $comision
 */
class Comision extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Comision the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comision}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_cuenta, id_planpago, comision', 'required'),
			array('id_cuenta, id_planpago', 'numerical', 'integerOnly'=>true),
			array('comision', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_comision, id_cuenta, id_planpago, comision', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCuenta' => array(self::BELONGS_TO, 'Cuenta', 'id_cuenta'),
			'idPlanpago' => array(self::BELONGS_TO, 'PlanPago', 'id_planpago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_comision' => 'Id Comision',
			'id_cuenta' => 'Cuenta',
			'id_planpago' => 'Plan de Pago',
			'comision' => 'Comisión',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_comision',$this->id_comision);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('id_planpago',$this->id_planpago);
		$criteria->compare('comision',$this->comision);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}