<?php

/**
 * This is the model class for table "{{categories}}".
 *
 * The followings are the available columns in table '{{categories}}':
 * @property integer $id_categorie
 * @property string $codigo
 * @property string $simpleCode
 * @property string $accommodationType
 * @property string $grupo
 * @property string $description
 */
class Categories extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Categories the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{categories}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('codigo, simpleCode, accommodationType, description', 'required'),
			array('codigo, simpleCode, grupo', 'length', 'max'=>5),
			array('accommodationType', 'length', 'max'=>8),
			array('description', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_categorie, codigo, simpleCode, accommodationType, grupo, description', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_categorie' => 'Id Categorie',
			'codigo' => 'Codigo',
			'simpleCode' => 'Simple Code',
			'accommodationType' => 'Accommodation Type',
			'grupo' => 'Grupo',
			'description' => 'Description',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_categorie',$this->id_categorie);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('simpleCode',$this->simpleCode,true);
		$criteria->compare('accommodationType',$this->accommodationType,true);
		$criteria->compare('grupo',$this->grupo,true);
		$criteria->compare('description',$this->description,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}