<?php



/**

 * This is the model class for table "{{cat_servicios}}".

 *

 * The followings are the available columns in table '{{cat_servicios}}':

 * @property integer $id_producto

 * @property string $descripcion

 * @property double $costo

 * @property double $precio

 * @property string $fecha

 * @property string $observacion

 *

 * The followings are the available model relations:

 * @property VentaDesglose[] $ventaDesgloses

 */

class CatServicios extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return CatServicios the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{cat_servicios}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(
            array('descripcion, costo, precio', 'required'),
            array('estatus, transportacion, visibilidad', 'numerical', 'integerOnly'=>true),
            array('costo, precio', 'numerical'),
            array('descripcion, origen, destino', 'length', 'max'=>200),
            array('tipo', 'length', 'max'=>50),
            array('imagen', 'length', 'max'=>255),
            array('observacion, observacion2', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id_producto, descripcion, origen, destino, tipo, costo, precio, fecha, observacion, observacion2, estatus, transportacion, visibilidad, imagen', 'safe', 'on'=>'search'),
        );

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'ventaDesgloses' => array(self::HAS_MANY, 'VentaDesglose', 'id_producto'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_producto' => 'Id Producto',

			'descripcion' => 'Nombre de Servicio',
			
			'origen' => 'Origen',
			
            'destino' => 'Destino',
			
            'tipo' => 'Tipo',

			'costo' => 'Precio Neto',

			'precio' => 'Precio Público',

			'fecha' => 'Fecha de Alta',

			'observacion' => 'Observación',
			
			'observacion2' => 'Observación Admin',
			
			'estatus' => 'Estatus',
			
			'visibilidad' => 'Visibilidad',
			
			'transportacion' => 'Transporte?',
			
			'imagen' => 'Imágen',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id_producto',$this->id_producto);
        $criteria->compare('descripcion',$this->descripcion,true);
        $criteria->compare('origen',$this->origen,true);
        $criteria->compare('destino',$this->destino,true);
        $criteria->compare('tipo',$this->tipo,true);
        $criteria->compare('costo',$this->costo);
        $criteria->compare('precio',$this->precio);
        $criteria->compare('fecha',$this->fecha,true);
        $criteria->compare('observacion',$this->observacion,true);
        $criteria->compare('observacion2',$this->observacion2,true);
        $criteria->compare('estatus',$this->estatus);
        $criteria->compare('transportacion',$this->transportacion);
        $criteria->compare('visibilidad',$this->visibilidad);
        $criteria->compare('imagen',$this->imagen,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

}