<?php



/**

 * This is the model class for table "{{cancelacion}}".

 *

 * The followings are the available columns in table '{{cancelacion}}':

 * @property integer $id

 * @property string $id_hotel

 * @property string $fecha_inicio

 * @property string $fecha_final

 * @property integer $dias

 * @property integer $penalizacion

 *

 * The followings are the available model relations:

 * @property Hoteles $idHotel

 */

class Cancelacion extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Cancelacion the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{cancelacion}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('fecha_inicio, fecha_final, dias, penalizacion', 'required'),

			array('dias, penalizacion', 'numerical', 'integerOnly'=>true),

			array('id_hotel', 'length', 'max'=>10),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id, id_hotel, fecha_inicio, fecha_final, dias, penalizacion', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id' => 'ID',

			'id_hotel' => 'Hotel',

			'fecha_inicio' => 'Fecha Inicio',

			'fecha_final' => 'Fecha Final',

			'dias' => 'Días',

			'penalizacion' => 'Penalización',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.

		


		$criteria=new CDbCriteria;


		if($_SESSION["tipoUsuario"] == "Hotel")

        {

	        	$id=Yii::app()->user->id;	
	         	$idHotel=HotelesExtranet::model()->findAll('idUsuario='.$id);
	         	$hotelesID=array();
	         foreach ($idHotel as $hotel) {
	         	 $hotelesID[]=$hotel->idHotel;
	         }

        	$criteria->addInCondition('id_hotel', $hotelesID);
        }

		$criteria->compare('id',$this->id);

		$criteria->compare('id_hotel',$this->id_hotel);

		if(isset($_GET['Cancelacion']['id_hotel']) && empty($this->id_hotel))$criteria->addCondition('id_hotel is null');

		if(!empty($this->fecha_inicio))$criteria->addCondition('fecha_inicio between "'.$this->fecha_inicio.'" and "'.$this->fecha_final.'"');



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

			'sort'=>array('defaultOrder'=>'fecha_inicio DESC'),

		));

	}

}