<?php

/**
 * This is the model class for table "{{bloqueos_productos}}".
 *
 * The followings are the available columns in table '{{bloqueos_productos}}':
 * @property integer $id_bloqueoProd
 * @property integer $id_producto
 * @property string $descripcion
 * @property integer $id_roominglist
 * @property integer $id_bloqueo
 * @property double $importe
 */
class BloqueosProductos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BloqueosProductos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bloqueos_productos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_roominglist, id_bloqueo, importe', 'required'),
			array('id_producto, id_usuario, id_roominglist, id_bloqueo', 'numerical', 'integerOnly'=>true),
			array('importe, estatus', 'numerical'),
			array('descripcion', 'length', 'max'=>50),
			array('motivoCancelacion', 'length', 'max'=>200),
			array('fecha, fechaCancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_bloqueoProd, id_producto, id_usuario, descripcion, id_roominglist, id_bloqueo, importe, fecha, fechaCancelacion, motivoCancelacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'roominglist0' => array(self::BELONGS_TO, 'Roominglist', 'id_roominglist'),
			'Productos0'=>array(self::BELONGS_TO, 'Productos', 'id_producto'),
			'usuarios0'=>array(self::BELONGS_TO, 'Usuarios', 'id_usuario')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_bloqueoProd' => 'Id Bloqueo Prod',
			'id_producto' => 'Id Producto',
			'descripcion' => 'Descripcion',
			'id_roominglist' => 'Id Roominglist',
			'id_bloqueo' => 'Id Bloqueo',
			'importe' => 'Importe',
			'fecha'=>'Fecha',
			'estatus'=>'Estatus',
			'fechaCancelacion'=> 'Fecha de Cancelación',
			'id_usuario'=>'idUsuario',
			'motivoCancelacion'=>'motivoCancelacion'

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_bloqueoProd',$this->id_bloqueoProd);
		$criteria->compare('id_producto',$this->id_producto);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('id_roominglist',$this->id_roominglist);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('fecha',$this->fecha);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('fechaCancelacion',$this->fechaCancelacion);
		$criteria->compare('motivoCancelacion',$this->motivoCancelacion);
		$criteria->compare('id_usuario',$this->id_usuario);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}