<?php

/**
 * This is the model class for table "{{bloqueos_ceremonias}}".
 *
 * The followings are the available columns in table '{{bloqueos_ceremonias}}':
 * @property integer $id_bloqueos_ceremonias
 * @property integer $id_bloqueo
 * @property string $ceremonia_primera
 * @property string $ceremonia_segunda
 * @property string $fecha_primera
 * @property string $fecha_segunda
 */
class BloqueosCeremonias extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BloqueosCeremonias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bloqueos_ceremonias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_bloqueo', 'required'),
			array('id_bloqueo', 'numerical', 'integerOnly'=>true),
			array('ceremonia_primera, ceremonia_segunda', 'length', 'max'=>100),
			array('fecha_primera, fecha_segunda', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_bloqueos_ceremonias, id_bloqueo, ceremonia_primera, ceremonia_segunda, fecha_primera, fecha_segunda', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_bloqueos_ceremonias' => 'Id Bloqueos Ceremonias',
			'id_bloqueo' => 'Id Bloqueo',
			'ceremonia_primera' => 'Ceremonia Primera',
			'ceremonia_segunda' => 'Ceremonia Segunda',
			'fecha_primera' => 'Fecha Primera',
			'fecha_segunda' => 'Fecha Segunda',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_bloqueos_ceremonias',$this->id_bloqueos_ceremonias);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('ceremonia_primera',$this->ceremonia_primera,true);
		$criteria->compare('ceremonia_segunda',$this->ceremonia_segunda,true);
		$criteria->compare('fecha_primera',$this->fecha_primera,true);
		$criteria->compare('fecha_segunda',$this->fecha_segunda,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}