<?php

/**
 * This is the model class for table "{{bloqueos}}".
 *
 * The followings are the available columns in table '{{bloqueos}}':
 * @property string $id_bloqueo
 * @property string $titulo
 * @property string $id_hotel
 * @property string $tipo
 * @property integer $id_agencia
 * @property double $comision
 * @property integer $id_paquete
 * @property string $novios
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $numero_habitaciones
 * @property string $id_tipo_plan
 * @property string $id_tipo_habitacion
 * @property string $id_tarifa
 * @property integer $tiempo_limite
 * @property integer $id_contrato
 * @property string $fecha_creacion
 * @property integer $id_usuario
 * @property string $observaciones
 * @property string $observaciones2
 * @property integer $estatus
 * @property integer $visibilidad
 * @property integer $es_promo
 *
 * The followings are the available model relations:
 * @property TarifaDesglose $idTarifa
 * @property Hoteles $idHotel
 */
class Bloqueos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bloqueos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bloqueos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, tipo, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, fecha_creacion, id_usuario', 'required'),
			array('id_agencia, id_paquete, tiempo_limite, id_contrato, id_usuario, estatus, visibilidad, es_promo', 'numerical', 'integerOnly'=>true),
			array('comision', 'numerical'),
			array('id_hotel, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, id_tarifa', 'length', 'max'=>10),
			array('tipo', 'length', 'max'=>20),
			array('novios', 'length', 'max'=>100),
			array('titulo, fecha_inicio, fecha_final, observaciones, observaciones2', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_bloqueo, titulo, id_hotel, tipo, id_agencia, comision, id_paquete, novios, fecha_inicio, fecha_final, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, id_tarifa, tiempo_limite, id_contrato, fecha_creacion, id_usuario, observaciones, observaciones2, estatus, visibilidad, es_promo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoPlan' => array(self::BELONGS_TO, 'Plan', 'id_tipo_plan'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'tarifaDesgloses' => array(self::BELONGS_TO, 'TarifaDesglose', array('id_tarifa'=>'id_tarifa'), 'together'=>true, 'joinType'=>'INNER JOIN', 'on'=>'tarifaDesgloses.id_tarifa=t.id_tarifa'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'bloqueoServicios' => array(self::HAS_MANY, 'ServNoComision', 'id_bloqueo'),
			'idHab'=>array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_bloqueo' => 'Id Bloqueo',
			'titulo' => 'Titulo',
			'id_hotel' => 'Id Hotel',
			'tipo' => 'Tipo',
			'id_agencia' => 'Id Agencia',
			'comision' => 'Comision',
			'id_paquete' => 'Id Paquete',
			'novios' => 'Novios',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'numero_habitaciones' => 'Numero Habitaciones',
			'id_tipo_plan' => 'Id Tipo Plan',
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'id_tarifa' => 'Id Tarifa',
			'tiempo_limite' => 'Tiempo Limite',
			'id_contrato' => 'Id Contrato',
			'fecha_creacion' => 'Fecha Creacion',
			'id_usuario' => 'Id Usuario',
			'observaciones' => 'Observaciones',
			'observaciones2' => 'Observaciones2',
			'estatus' => 'Estatus',
			'visibilidad' => 'Visibilidad',
			'es_promo' => 'Es Promo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('id_paquete',$this->id_paquete);
		$criteria->compare('novios',$this->novios,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('numero_habitaciones',$this->numero_habitaciones,true);
		$criteria->compare('id_tipo_plan',$this->id_tipo_plan,true);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('tiempo_limite',$this->tiempo_limite);
		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('observaciones2',$this->observaciones2,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('visibilidad',$this->visibilidad);
		$criteria->compare('es_promo',$this->es_promo);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}