<?php

/**
 * This is the model class for table "{{bitacora_errores}}".
 *
 * The followings are the available columns in table '{{bitacora_errores}}':
 * @property integer $id
 * @property string $fecha_creado
 * @property string $nombre
 * @property string $descripcion
 * @property string $solucion
 * @property string $estatus
 * @property string $fecha_corregido
 */
class BitacoraErrores extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BitacoraErrores the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bitacora_errores}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, descripcion, estatus', 'required'),
			array('nombre', 'length', 'max'=>255),
			array('estatus', 'length', 'max'=>11),
			array('solucion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, fecha_creado, nombre, descripcion, solucion, estatus, fecha_corregido', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'Ticket',
			'fecha_creado' => 'Fecha de Creado',
			'nombre' => 'Nombre',
			'descripcion' => 'Descripción',
			'solucion' => 'Solución',
			'estatus' => 'Estatus',
			'fecha_corregido' => 'Fecha de Corregido',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('fecha_creado',$this->fecha_creado,true);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('solucion',$this->solucion,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('fecha_corregido',$this->fecha_corregido,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}