<?php

/**
 * This is the model class for table "{{auth_funcion}}".
 *
 * The followings are the available columns in table '{{auth_funcion}}':
 * @property integer $id
 * @property string $operacion
 * @property string $funcion
 * @property string $controlador
 */
class AuthFuncion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AuthFuncion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{auth_funcion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('operacion, funcion, controlador', 'required'),
			array('operacion, funcion, controlador', 'length', 'max'=>64),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, operacion, funcion, controlador', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'operacion' => 'Operacion',
			'funcion' => 'Funcion',
			'controlador' => 'Controlador',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('operacion',$this->operacion,true);
		$criteria->compare('funcion',$this->funcion,true);
		$criteria->compare('controlador',$this->controlador,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}