<?php

/**
 * This is the model class for table "{{apiexcepciones}}".
 *
 * The followings are the available columns in table '{{apiexcepciones}}':
 * @property integer $idApiEx
 * @property integer $idApi
 * @property string $code
 * @property integer $descartar
 * @property string $params
 *
 * The followings are the available model relations:
 * @property Api $idApi0
 */
class Apiexcepciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Apiexcepciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{apiexcepciones}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('idApi, code, descartar, params', 'required'),
			array('idApi, descartar', 'numerical', 'integerOnly'=>true),
			array('code', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idApiEx, idApi, code, descartar, params', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idApi0' => array(self::BELONGS_TO, 'Api', 'idApi'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idApiEx' => 'Id Api Ex',
			'idApi' => 'Id Api',
			'code' => 'Code',
			'descartar' => 'Descartar',
			'params' => 'Params',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idApiEx',$this->idApiEx);
		$criteria->compare('idApi',$this->idApi);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('descartar',$this->descartar);
		$criteria->compare('params',$this->params,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}