<?php

/**
 * This is the model class for table "{{agencias_interesadas_outlet}}".
 *
 * The followings are the available columns in table '{{agencias_interesadas_outlet}}':
 * @property integer $id
 * @property string $nombre_agencia
 * @property string $correo
 * @property string $telefono
 * @property string $ciudad
 * @property string $estado
 * @property string $direccion
 * @property string $segmento
 * @property string $facebook
 * @property string $instagram
 * @property string $web
 * @property string $log
 */
class AgenciasInteresadasOutlet extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AgenciasInteresadasOutlet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{agencias_interesadas_outlet}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id, nombre_agencia, log', 'required'),
			array('id', 'numerical', 'integerOnly'=>true),
			array('nombre_agencia, ciudad, estado, facebook, instagram, web', 'length', 'max'=>100),
			array('correo', 'length', 'max'=>50),
			array('telefono', 'length', 'max'=>10),
			array('direccion, segmento', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, nombre_agencia, correo, telefono, ciudad, estado, direccion, segmento, facebook, instagram, web, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'nombre_agencia' => 'Nombre Agencia',
			'correo' => 'Correo',
			'telefono' => 'Telefono',
			'ciudad' => 'Ciudad',
			'estado' => 'Estado',
			'direccion' => 'Direccion',
			'segmento' => 'Segmento',
			'facebook' => 'Facebook',
			'instagram' => 'Instagram',
			'web' => 'Web',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('nombre_agencia',$this->nombre_agencia,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('ciudad',$this->ciudad,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('segmento',$this->segmento,true);
		$criteria->compare('facebook',$this->facebook,true);
		$criteria->compare('instagram',$this->instagram,true);
		$criteria->compare('web',$this->web,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}